	function [Gbp, Zbp, Pbp] = PZ_2_BP_Z(Gd, Zd, Pd, wc1T, wc2T, OmegacT);
 
	% 	Transforms the poles and zeros of a digital lowpass filter with   
	% 	cutoff frequency, OmegacT, to a bandpass filter with passband  
	%	edges wc1T and wc2T.
 
	%	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2009-11-15
	% Modified by: 	 	LW 2016-05-14
	% Copyright:		by authors - not released for commercial use
	% Version:			1 
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com

	alfa = cos((wc1T + wc2T)/2)/cos((wc2T- wc1T)/2);
	k = cot((wc2T- wc1T)/2)*tan(OmegacT/2);
	beta = 2*alfa*k/(k+1);
	gama = (k-1)/(k+1);
	
	Zbp = zeros(1,2*length(Zd));
	for n = 1:length(Zd)		 
		Z0 = roots([gama*Zd(n)+1 -beta*(Zd(n)+1) Zd(n)+gama]);
			Zbp(1,n) = Z0(1,1);
			Zbp(1,n+length(Zd)) = Z0(2,1);
		end
		Zbp = sort(Zbp);
	Pbp = zeros(1,2*length(Zd));
	for n = 1:length(Pd)		 
		Z0 = roots([gama*Pd(n)+1 -beta*(Pd(n)+1) Pd(n)+gama]);
		Pbp(1,n) = Z0(1,1); Pbp(1,n+length(Pd)) = Z0(2,1);
	end
	Pbp = sort(Pbp);
	wT = linspace(0, pi, 1000);
	Gbp = 1/max(abs(PZ_2_FREQ_Z(1, Zbp, Pbp, wT)));
